<?php

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  Script: Maian Gallery v2.0
  Written by: David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: http://www.maianscriptworld.co.uk

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  
  This File: class_watermarker.inc.php
  Description: Image Watermark Class
  Written by: Hasin Hayder
  Modified by: David Ian Bennett

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

class waterMarker extends genericOptions {

var $imagePath;
var $waterMarkText;
var $signature       = 'version 1.0';
var $font            = '../fonts/arial.ttf';
var $size;
var $angle;
var $hSpacing;
var $vSpacing;
var $imageResource;
var $imageType       = 'jpg';
var $shadow          = false;
var $antialiased     = true;
var $red;
var $green;
var $blue;

// Draws watermark over image
function mark()
{
  list($width, $height, $type, $attr) = getimagesize($this->imagePath);

	switch ($this->imageType) {
	  case "png":
	  $createProc = "imagecreatefrompng";
	  $outputProc = "imagepng";
	  break;

	  case "gif":
	  $createProc = "imagecreatefromgif";
    $outputProc = "imagepng";
    break;

    case "bmp":
	  $createProc = "imagecreatefrombmp";
    $outputProc = "imagebmp";
    break;

    case "jpeg":
	  case "jpg":
	  $createProc = "imagecreatefromjpeg";
    $outputProc = "imagejpeg";
    break;
  }

	$im           = $createProc($this->imagePath);
  $grey         = imagecolorallocate($im, $this->red, $this->green, $this->blue);
	$shadowColor  = imagecolorallocate($im, 130, 130, 130);

  if (!$this->antialiased) {
	  $grey *= -1;
		$shadowColor *= -1;
  }
  
  if (!function_exists('imagettftext')) {
    die('You do not have the GD library instaled or enabled!! Or you do have it enabled, but Freetype support isn`t enabled. Contact your host!');
  }

	for ($x=20; $x<$width; $x+=$this->hSpacing) {
    for ($y=20; $y<$height; $y+=$this->vSpacing) {
      if ($this->shadow) {
        imagettftext($im, $this->size, $this->angle, $x+1, $y+1, $shadowColor, $this->font, $this->waterMarkText);
      }

      imagettftext($im, $this->size, $this->angle, $x, $y, $grey, $this->font, $this->waterMarkText);
    }
  }

  $this->imageResource = $outputProc($im);
}

}
?>
